package ru.yandex.webmaster3.viewer.http.camelcase.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.HostDisplayNameModerationRequestState;

import java.util.UUID;

/**
 * User: azakharov
 * Date: 27.08.14
 * Time: 16:21
 */
public class DisplayNameRequestView {
    private final WebmasterHostId hostId;
    private final BeautyHostName beautyHostName;
    private final String displayName;
    private final HostDisplayNameModerationRequestState state;
    private final DateTime creationDate;
    private final DateTime modificationDate;
    private final UUID requestId;

    public DisplayNameRequestView(WebmasterHostId hostId, UUID requestId, BeautyHostName beautyHostName, String displayName, HostDisplayNameModerationRequestState state, DateTime creationDate, DateTime modificationDate) {
        this.hostId = hostId;
        this.beautyHostName = beautyHostName;
        this.state = state;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.requestId = requestId;
        this.displayName = displayName;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public BeautyHostName getBeautyHostName() {
        return beautyHostName;
    }

    public HostDisplayNameModerationRequestState getState() {
        return state;
    }

    public DateTime getCreationDate() {
        return creationDate;
    }

    public DateTime getModificationDate() {
        return modificationDate;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public String getDisplayName() {
        return displayName;
    }
}
