package ru.yandex.webmaster3.viewer.http.checklist;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ChecklistHistoryRequest extends AbstractUserVerifiedHostRequest {
    private List<String> types;

    public List<String> getTypes() {
        return types;
    }

    @Description("Типы проблем, которые будут включены в ответ. " +
                 "Если этот параметр равен null, в ответ будут включены все типы. " +
                 "Возможные значения: инстансы SiteProblemTypeEnum. Невалидные значения игнорируются.")
    @RequestQueryProperty
    public void setTypes(List<String> types) {
        this.types = types;
    }
}
