package ru.yandex.webmaster3.viewer.http.checklist;

import java.util.List;

import lombok.Value;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.common.response.HostHealth;

/**
 * @author avhaliullin
 */
@Value
public class ChecklistInfoResponse implements ActionResponse.NormalResponse {
    HostHealth health;
    List<ProblemInfo> problems;
    int turboContentProblemsCount;
    int turboShopProblemsCount;

    public static class ProblemInfo {
        private final SiteProblemTypeEnum problemType;
        private final SiteProblemSeverityEnum severity;
        @Nullable
        private final SiteProblemContent info;
        private final SiteProblemState state;
        private final int weight;
        private final boolean isRecheckable;
        private final boolean recheckRequested;
        private final DateTime recheckRequestDate;
        private final DateTime actualSince;
        private final boolean hasSamples;
        private final boolean recheckFailed;

        public ProblemInfo(SiteProblemTypeEnum problemType, @Nullable SiteProblemContent info, SiteProblemState state,
                           int weight, boolean isRecheckable, boolean recheckRequested, DateTime recheckRequestDate,
                           DateTime actualSince, boolean hasSamples, boolean recheckFailed) {
            this.problemType = problemType;
            this.isRecheckable = isRecheckable;
            this.recheckRequested = recheckRequested;
            this.recheckRequestDate = recheckRequestDate;
            this.actualSince = actualSince;
            this.severity = problemType.getSeverity();
            this.info = info;
            this.state = state;
            this.weight = weight;
            this.hasSamples = hasSamples;
            this.recheckFailed = recheckFailed;
        }

        public SiteProblemTypeEnum getProblemType() {
            return problemType;
        }

        public SiteProblemSeverityEnum getSeverity() {
            return severity;
        }

        @Nullable
        public SiteProblemContent getInfo() {
            return info;
        }

        public SiteProblemState getState() {
            return state;
        }

        public int getWeight() {
            return weight;
        }

        public boolean isRecheckable() {
            return isRecheckable;
        }

        public boolean isRecheckRequested() {
            return recheckRequested;
        }

        public DateTime getRecheckRequestDate() {
            return recheckRequestDate;
        }

        @Description("Дата последнего изменения состояния, null, если 'так было всегда'")
        public DateTime getActualSince() {
            return actualSince;
        }

        @Description("Есть ли примеры (имеет смысл только для некоторых конкретных типов проблем)")
        public boolean isHasSamples() {
            return hasSamples;
        }

        public boolean isRecheckFailed() {
            return recheckFailed;
        }
    }
}
