package ru.yandex.webmaster3.viewer.http.checklist;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.events2.HostEventId;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsRecheckService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@WriteAction
@Description("Запросить перепроверку для проблемы")
@Category("checklist")
@Component("/checklist/recheck")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ChecklistRecheckProblemAction extends AbstractUserVerifiedHostAction<ChecklistRecheckProblemRequest, ChecklistRecheckProblemResponse> {
    private final SiteProblemsRecheckService siteProblemsRecheckService;

    @Override
    public ChecklistRecheckProblemResponse process(ChecklistRecheckProblemRequest request) {
        HostEventId eventId = HostEventId.createFromUserRequest(request.getBalancerRequestId(), request.getUserId());
        siteProblemsRecheckService.requestSiteProblemRecheck(eventId, request.getHostId(), request.getProblemType());
        return new ChecklistRecheckProblemResponse();
    }
}
