package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistPageSamplesService;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistSamplesType;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Получить примеры проблемных урлов из чеклиста")
@Category("checklist")
public class AbstractPageSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, PageSamplesResponse> {
    @Autowired
    private ChecklistPageSamplesService checklistPageSamplesService;
    @Setter
    private ChecklistSamplesType samplesType;

    @Override
    public PageSamplesResponse process(PageSamplesRequest request) {
        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        List<String> samples = checklistPageSamplesService.getSamples(request.getHostId(), samplesType);
        List<PageSamplesResponse.PageSample> results = samples.stream()
                .skip(pager.toRangeStart())
                .limit(pager.getPageSize())
                .map(url -> {
                    try {
                        return new PageSamplesResponse.PageSample(new URL(IdUtils.hostIdToUrl(request.getHostId()) + url));
                    } catch (MalformedURLException e) {
                        throw new RuntimeException("Malformed url in page samples", e);
                    }
                }).collect(Collectors.toList());
        return new PageSamplesResponse(results, samples.size());
    }

}
