package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.MicrodataDocStatus;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.checklist.dao.MicrodataErrorSamplesYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Примеры страниц с битой микроразметкой")
@Category("checklist")
@Service("/checklist/extras/brokenMicrodataPageSamples")
public class BrokenMicrodataPageSampesAction extends AbstractUserVerifiedHostAction<BrokenMicrodataPageSamplesRequest, BrokenMicrodataPageSamplesResponse> {
    @Autowired
    private MicrodataErrorSamplesYDao microdataErrorSamplesYDao;

    @Override
    public BrokenMicrodataPageSamplesResponse process(BrokenMicrodataPageSamplesRequest request) {
        try {
            Map<MicrodataDocStatus, List<String>> samples = microdataErrorSamplesYDao.getSamples(request.getHostId());
            MicrodataErrorType errorType = request.getErrorType();
            List<BrokenMicrodataPageSamplesResponse.ErrorTypeInfo> errorTypeInfos = new ArrayList<>();
            Map<MicrodataErrorType, List<String>> errorTypeToSamples = new EnumMap<>(MicrodataErrorType.class);

            errorTypeToSamples.put(MicrodataErrorType.ERROR, samples.getOrDefault(MicrodataDocStatus.INVALID, Collections.emptyList()));
            errorTypeToSamples.put(MicrodataErrorType.WARNING, samples.getOrDefault(MicrodataDocStatus.WARNING, Collections.emptyList()));

            for (Map.Entry<MicrodataErrorType, List<String>> entry : errorTypeToSamples.entrySet()) {
                errorTypeInfos.add(new BrokenMicrodataPageSamplesResponse.ErrorTypeInfo(entry.getKey(), entry.getValue().size()));
            }

            if (errorType == null) {
                if (!errorTypeToSamples.get(MicrodataErrorType.ERROR).isEmpty()) {
                    errorType = MicrodataErrorType.ERROR;
                } else {
                    errorType = MicrodataErrorType.WARNING;
                }
            }

            PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());

            List<String> relUrlsPage = errorTypeToSamples.get(errorType)
                    .stream()
                    .skip(pager.toRangeStart())
                    .limit(pager.getPageSize())
                    .map(s -> IdUtils.hostIdToUrl(request.getHostId()) + s)
                    .collect(Collectors.toList());

            return new BrokenMicrodataPageSamplesResponse(
                    errorType,
                    relUrlsPage,
                    errorTypeToSamples.get(errorType).size(),
                    errorTypeInfos
            );
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get samples", new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }
}
