package ru.yandex.webmaster3.viewer.http.checklist.extras;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class BrokenMicrodataPageSamplesResponse implements ActionResponse.NormalResponse {
    private final MicrodataErrorType selectedType;
    private final List<PageSample> samples;
    private final int totalSamples;
    private final List<ErrorTypeInfo> typeInfos;

    public BrokenMicrodataPageSamplesResponse(MicrodataErrorType selectedType, List<String> samples, int totalSamples, List<ErrorTypeInfo> typeInfos) {
        this.selectedType = selectedType;
        this.samples = samples.stream().map(PageSample::new).collect(Collectors.toList());
        this.totalSamples = totalSamples;
        this.typeInfos = typeInfos;
    }

    @Description("тип ошибки, для которого показаны результаты")
    public MicrodataErrorType getSelectedType() {
        return selectedType;
    }

    @Description("примеры урлов")
    public List<PageSample> getSamples() {
        return samples;
    }

    @Description("количество урлов (для пейджера)")
    public int getTotalSamples() {
        return totalSamples;
    }

    @Description("сводная информация о всех типах ошибок")
    public List<ErrorTypeInfo> getTypeInfos() {
        return typeInfos;
    }

    public static class ErrorTypeInfo {
        private final MicrodataErrorType type;
        private final int totalSamples;

        public ErrorTypeInfo(MicrodataErrorType type, int totalSamples) {
            this.type = type;
            this.totalSamples = totalSamples;
        }

        @Description("количество ошибок указанного типа")
        public int getTotalSamples() {
            return totalSamples;
        }

        public MicrodataErrorType getType() {
            return type;
        }
    }

    public static class PageSample {
        private final String url;

        public PageSample(String url) {
            this.url = url;
        }

        public String getUrl() {
            return url;
        }
    }
}