package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.hoststat.HostStatistics;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.checklist.data.problems.DuplicatedPage;
import ru.yandex.webmaster3.storage.hoststat.HostStatisticsCHDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Примеры дублирующихся страниц")
@Category("checklist")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class DuplicatePageSamplesAction extends AbstractUserVerifiedHostAction<DuplicatePageSamplesRequest, DuplicatePageSamplesResponse> {
    private final HostStatisticsCHDao hostStatisticsCHDao;

    @Override
    public DuplicatePageSamplesResponse process(DuplicatePageSamplesRequest request) {
        HostStatistics hostStatistics = hostStatisticsCHDao.getHostStatisticsWithSamples(request.getHostId());
        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        List<DuplicatedPage> result = hostStatistics.getDuplicatePageSamples().stream()
                .skip(pager.toRangeStart())
                .limit(pager.getPageSize())
                .map(sample -> new DuplicatedPage(IdUtils.hostIdToUrl(request.getHostId()) + sample.getPath(), sample.getMainUrl(),
                        sample.getLastAccess() == null ? null : new DateTime(sample.getLastAccess() * 1000L)))
                .collect(Collectors.toList());

        return new DuplicatePageSamplesResponse(result, hostStatistics.getDuplicatePageSamples().size());
    }

}
