package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.UrlUtils;
import ru.yandex.webmaster3.storage.checklist.data.RealTimeSiteProblemInfo;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Примеры страниц с незначащами CGI параметрами")
@Category("checklist")
    @Component("/checklist/extras/insignificantCGIsamples")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class InsignificantCGIParametersPageSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, InsignificantCGIParametersPageSamplesAction.Response> {
    private final SiteProblemsService siteProblemsService;

    @Override
    public Response process(PageSamplesRequest request) {
        final RealTimeSiteProblemInfo realTimeProblemInfo = siteProblemsService.getRealTimeProblemInfo(request.getHostId(), SiteProblemTypeEnum.INSIGNIFICANT_CGI_PARAMETER);
        if (realTimeProblemInfo == null) {
            return new Response(List.of(), 0);
        }
        final SiteProblemContent.InsignificantCGIParameter content = (SiteProblemContent.InsignificantCGIParameter) realTimeProblemInfo.getContent();
        if (content == null) {
            return new Response(List.of(), 0);
        }
        List<CGISamples> result = new ArrayList<>();
        final String host = IdUtils.hostIdToUrl(request.getHostId());
        for (Map.Entry<String, List<String>> item : content.getCgiParameters().entrySet()) {
            List<String> samples = new ArrayList<>(item.getValue().size());
            List<ExtendedUrlSample> extendedSamples = new ArrayList<>(item.getValue().size());
            for (String url : item.getValue()) {
                samples.add(host + url);
                extendedSamples.add(new ExtendedUrlSample(host + url, item.getKey()));
            }
            result.add(new CGISamples(item.getKey(), samples, extendedSamples));
        }
        return new Response(result, result.size());
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        List<CGISamples> samples;
        long totalSamples;
    }

    @Value
    public static class ExtendedUrlSample {
        String url;
        String mainUrl;

        public ExtendedUrlSample(String url, String param) {
            this.url = url;
            this.mainUrl = UrlUtils.removeParameter(url, param);
        }
    }

    @Value
    public static class CGISamples {
        String reason;
        List<String> urls;
        List<ExtendedUrlSample> extendedUrls;
    }

}
