package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistPageSamplesService;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistSamplesType;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCrawlLostHitsUrlSample;
import ru.yandex.webmaster3.storage.util.JsonDBMapping;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author leonidrom
 */
@Description("Страница с примерами урлов с потерянными хитами по метрике")
@ReadAction
@Category("checklist")
@Slf4j
public class MetrikaCrawlLostHitsSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, PageSamplesResponse> {
    private ChecklistPageSamplesService checklistPageSamplesService;
    private ChecklistSamplesType samplesType;

    @Override
    public PageSamplesResponse process(PageSamplesRequest request) {
        WebmasterHostId hostId = request.getHostId();
        List<MetrikaCrawlLostHitsUrlSample> samples = checklistPageSamplesService.getSamples(hostId, samplesType).stream()
                .map(s -> {
                    try {
                        return JsonDBMapping.OM.readValue(s, MetrikaCrawlLostHitsUrlSample.class);
                    } catch (IOException e) {
                        throw new WebmasterException("Json error", new WebmasterErrorResponse.InternalUnknownErrorResponse(
                                getClass(), "Unknown JSON error"), e);
                    }
                })
                .collect(Collectors.toList());

        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        List<PageSamplesResponse.PageSample> results = samples.stream()
                .skip(pager.toRangeStart())
                .limit(pager.getPageSize())
                .map(s -> {
                    try {
                        return new PageSamplesResponse.PageSample(new URL(s.getUrl()));
                    } catch (MalformedURLException e) {
                        throw new WebmasterException("Unexpected error", new WebmasterErrorResponse.InternalUnknownErrorResponse(
                                getClass(), "Unexpected error"), e);
                    }
                })
                .collect(Collectors.toList());

        return new PageSamplesResponse(results, results.size());
    }

    @Autowired
    public void setChecklistPageSamplesService(ChecklistPageSamplesService checklistPageSamplesService) {
        this.checklistPageSamplesService = checklistPageSamplesService;
    }

    public void setSamplesType(ChecklistSamplesType samplesType) {
        this.samplesType = samplesType;
    }
}
