package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.hoststat.HostStatistics;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistSamplesType;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsService;
import ru.yandex.webmaster3.storage.hoststat.HostStatisticsCHDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Получить примеры проблемных урлов для отсутствующих тайтлов/дескрипшенов")
@Category("checklist")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class MissingContentAttrsSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, PageSamplesResponse> {

    private final HostStatisticsCHDao hostStatisticsCHDao;
    @Setter
    private boolean title;

    @Override
    public PageSamplesResponse process(PageSamplesRequest request) {
        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        HostStatistics hostStatistics = hostStatisticsCHDao.getHostStatisticsWithSamples(request.getHostId());
        if (hostStatistics == null) {
            return new PageSamplesResponse(Collections.emptyList(), 0);
        }

        List<HostStatistics.PageSample> samples = title ? hostStatistics.getEmptyTitleSamples() : hostStatistics.getEmptyDescriptionSamples();

        List<PageSamplesResponse.PageSample> results = samples.stream()
                .skip(pager.toRangeStart())
                .limit(pager.getPageSize())
                .map(pageSample -> {
                    try {
                        return new PageSamplesResponse.PageSample(new URL(IdUtils.hostIdToUrl(request.getHostId()) + pageSample.getPath()));
                    } catch (MalformedURLException e) {
                        throw new RuntimeException("Malformed url in page samples", e);
                    }
                }).collect(Collectors.toList());
        return new PageSamplesResponse(results, samples.size());
    }
}
