package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.NotMobileFriendlyStatus;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistPageSamplesService;
import ru.yandex.webmaster3.storage.checklist.dao.ChecklistSamplesType;
import ru.yandex.webmaster3.storage.checklist.data.AbstractProblemInfo;
import ru.yandex.webmaster3.storage.checklist.data.problems.MobileUrlSample;
import ru.yandex.webmaster3.storage.checklist.service.SiteProblemsService;
import ru.yandex.webmaster3.storage.util.JsonDBMapping;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@Description("Страница с примерами немобилопригодных урлов")
@ReadAction
@Category("checklist")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class NotMobileFriendlyPageSamplesAction extends AbstractUserVerifiedHostAction<NotMobileFriendlyPageSamplesRequest, NotMobileFriendlyPageSamplesResponse> {


    private final SiteProblemsService siteProblemsService;
    private final ChecklistPageSamplesService checklistPageSamplesService;

    @Override
    public NotMobileFriendlyPageSamplesResponse process(NotMobileFriendlyPageSamplesRequest request) {
        AbstractProblemInfo problemInfo = siteProblemsService.getRealTimeProblemInfo(request.getHostId(), SiteProblemTypeEnum.NOT_MOBILE_FRIENDLY);
        if (problemInfo == null || problemInfo.getState() != SiteProblemState.PRESENT) {
            return new NotMobileFriendlyPageSamplesResponse(null, Collections.emptyMap(), 0);
        }
        SiteProblemContent.NotMobileFriendly problemContent = (SiteProblemContent.NotMobileFriendly) problemInfo.getContent();
        List<MobileUrlSample> samples = checklistPageSamplesService.getSamples(
                request.getHostId(), ChecklistSamplesType.NOT_MOBILE_FRIENDLY).stream().map(s -> {
            try {
                return JsonDBMapping.OM.readValue(s, MobileUrlSample.class);
            } catch (IOException e) {
                throw new WebmasterException("Json error", new WebmasterErrorResponse.InternalUnknownErrorResponse(
                        getClass(), "Unknown JSON error"));
            }
        }).collect(Collectors.toList());

        Map<NotMobileFriendlyStatus, List<MobileUrlSample>> samplesMap = new HashMap<>();
        for (NotMobileFriendlyStatus status : NotMobileFriendlyStatus.values()) {
            samplesMap.put(status, new ArrayList<>());
        }

        for (MobileUrlSample sample : samples) {
            NotMobileFriendlyStatus sampleType = sample.getSampleType();
            if (sampleType == null || !samplesMap.containsKey(sampleType)) {
                //для самплов старого формата
                sampleType = NotMobileFriendlyStatus.NOT_MOBILE_FRIENDLY;
            }
            samplesMap.get(sampleType).add(sample);
            
        }

        return new NotMobileFriendlyPageSamplesResponse(problemContent, samplesMap, samples.size());
    }

}
