package ru.yandex.webmaster3.viewer.http.checklist.extras;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.net.URL;
import java.util.List;

/**
 * @author avhaliullin
 */
public class PageSamplesResponse implements ActionResponse.NormalResponse {
    private final List<PageSample> samples;
    private final int totalSamples;

    public PageSamplesResponse(List<PageSample> samples, int totalSamples) {
        this.samples = samples;
        this.totalSamples = totalSamples;
    }

    public List<PageSample> getSamples() {
        return samples;
    }

    public int getTotalSamples() {
        return totalSamples;
    }

    public static class PageSample {
        private final URL url;

        public PageSample(URL url) {
            this.url = url;
        }

        public URL getUrl() {
            return url;
        }
    }
}
