package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.checklist.data.TurboHostBanSample;
import ru.yandex.webmaster3.storage.turbo.dao.autodelete.TurboAutoDeletedPagesSamplesYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author: iceflame
 * DATE: 19.02.2021
 */
@ReadAction
@Description("Получить примеры автоудаленных страниц турбо ")
@Category("checklist")
@Component("/checklist/extras/turboAutoDeletedPagesSamples")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class TurboAutoDeletedPagesSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, TurboAutoDeletedPagesSamplesAction.Response> {

    private final TurboAutoDeletedPagesSamplesYDao turboAutoDeletedPagesSamplesYDao;

    @Override
    public Response process(PageSamplesRequest request) {
        List<TurboHostBanSample> samples = turboAutoDeletedPagesSamplesYDao.getSamples(WwwUtil.cutWWWAndM(request.getHostId()));
        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        return new Response(samples.subList(pager.toRangeStart(), Math.min(samples.size(), pager.toRangeStart() + pager.getPageSize())), samples.size());
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        List<TurboHostBanSample> samples;
        int totalSamples;
    }

}
