package ru.yandex.webmaster3.viewer.http.checklist.extras;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.checklist.data.TurboBanSample;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.PageUtils;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.checklist.data.RealTimeSiteProblemInfo;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsStateCHDao;
import ru.yandex.webmaster3.storage.turbo.service.TurboDomainsStateService.TurboDomainState;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.checklist.extras.TurboBanSamplesAction.Response;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Получить примеры проблемных страниц с банами турбо")
@Category("checklist")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class TurboBanSamplesAction extends AbstractUserVerifiedHostAction<PageSamplesRequest, Response> {

    private final SiteProblemTypeEnum problemType;
    private final TurboDomainsStateCHDao turboDomainsStateCHDao;

    @Override
    public Response process(PageSamplesRequest request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        TurboDomainState domainState = turboDomainsStateCHDao.getDomainStateOnlyProblems(domain);
        RealTimeSiteProblemInfo problem = domainState.getProblems().stream()
                .filter(p -> p.getProblemType() == problemType).findAny().orElse(null);
        if (problem == null) {
            return new Response(Collections.emptyList(), 0);
        }
        PageUtils.Pager pager = PageUtils.getPage(request.getP(), request.getPSize());
        List<TurboBanSample> samples = ((SiteProblemContent.TurboBanContent) problem.getContent()).getSamples();
        return new Response(samples.stream().skip(pager.toRangeStart()).limit(pager.getPageSize()).collect(Collectors.toList()), samples.size());
    }

    public static final class Response implements ActionResponse.NormalResponse {

        private final List<TurboBanSample> samples;
        private final int totalSamples;

        public Response(List<TurboBanSample> samples, int totalSamples) {
            this.samples = samples;
            this.totalSamples = totalSamples;
        }

        public List<TurboBanSample> getSamples() {
            return samples;
        }

        public int getTotalSamples() {
            return totalSamples;
        }
    }
}
