package ru.yandex.webmaster3.viewer.http.comment;

import java.util.List;
import java.util.stream.Collectors;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.comment.CmntIntegraionService;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * ishalaru
 * 20.12.2019
 **/
@ReadAction
@Description(value = "Получить дополнительную информацию по чату")
@Category("comment")
@Slf4j
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Component("/comment/init")
public class ChatsInitializationAction extends
        BaseWebmaster3Action<ChatsInitializationAction.Request, ChatsInitializationAction.Response> {
    private final CmntIntegraionService cmntIntegraionService;

    @Override
    public Response process(Request request) {
        List<String> reviewIds = request.getReviewIds().stream().distinct().collect(Collectors.toList());
        if (!cmntIntegraionService.initChats(reviewIds)) {
            throw new WebmasterException("Chats can't be initialized: ",
                    new WebmasterErrorResponse.CmntErrorResponse(getClass(), null), null);
        }
        return new Response();
    }

    @Getter
    @Setter(onMethod_ = {@RequestQueryProperty})
    public static class Request extends AbstractFrontendRequest {
        @Description("ID отзыва, оно же ID чата")
        private List<String> reviewIds;
    }

    public static class Response implements ActionResponse.NormalResponse {

    }

}
