package ru.yandex.webmaster3.viewer.http.common.response;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
* @author aherman
*/
public class CommonHostInfo {
    private final WebmasterHostId.Schema schema;
    private final String displayName;
    private final String punycodeHostname;
    private final WebmasterHostId webmasterHostId;
    private final boolean pinned;
    private final HostHealth hostHealth;

    public CommonHostInfo(WebmasterHostId hostId, String displayName, boolean pinned, HostHealth hostHealth) {
        this.hostHealth = hostHealth;
        this.schema = hostId.getSchema();
        this.displayName = displayName;
        this.punycodeHostname = hostId.getPunycodeHostname();
        this.webmasterHostId = hostId;
        this.pinned = pinned;
    }

    public WebmasterHostId.Schema getSchema() {
        return schema;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getPunycodeHostname() {
        return punycodeHostname;
    }

    public WebmasterHostId getWebmasterHostId() {
        return webmasterHostId;
    }

    public boolean isPinned() {
        return pinned;
    }

    public HostHealth getHostHealth() {
        return hostHealth;
    }
}
