package ru.yandex.webmaster3.viewer.http.common.response;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.storage.checklist.data.ExtendedProblem;
import ru.yandex.webmaster3.storage.checklist.data.ProblemSignal;
import ru.yandex.webmaster3.storage.checklist.data.SummarySiteProblemsInfo;
import ru.yandex.webmaster3.storage.checklist.util.SiteProblemWeightUtil;
import ru.yandex.webmaster3.storage.host.HostDataState;

import java.util.List;

/**
 * @author avhaliullin
 */
public class HostHealth {
    private final int currentHealth;
    private final int totalPossibleHealth;

    public HostHealth(int currentHealth, int totalPossibleHealth) {
        this.currentHealth = currentHealth;
        this.totalPossibleHealth = totalPossibleHealth;
    }

    public int getCurrentHealth() {
        return currentHealth;
    }

    public int getTotalPossibleHealth() {
        return totalPossibleHealth;
    }

    public HealthStatus getStatus() {
        //TODO: Это диапазоны из моей головы. Все это сделано во имя API. Подкрутим по велению менеджера ближе к запуску.
        double relHealth = (currentHealth + 0.0d) / totalPossibleHealth;
        if (relHealth < 0.5) {
            return HealthStatus.VERY_BAD;
        } else if (relHealth < 0.6) {
            return HealthStatus.BAD;
        } else if (relHealth < 0.8) {
            return HealthStatus.NORMAL;
        } else {
            return HealthStatus.GOOD;
        }
    }

    public static <T extends ProblemSignal> HostHealth fromProblemsList(List<ExtendedProblem<T>> problems) {
        int summaryWeight = 0;
        int totalHealth = SiteProblemWeightUtil.TOTAL_PROBLEMS_WEIGHT;
        boolean haveFatal = false;
        for (ExtendedProblem<?> problem : problems) {
            switch (problem.getProblem().getState()) {
                case PRESENT:
                    if (problem.getProblem().getProblemType().getSeverity() == SiteProblemSeverityEnum.FATAL) {
                        haveFatal = true;
                    } else {
                        summaryWeight += problem.getWeight();
                    }
                    break;
                case UNDEFINED:
                    totalHealth -= problem.getWeight();
                    break;
            }
        }

        return new HostHealth(haveFatal ? 0 : totalHealth - summaryWeight, totalHealth);
    }

    public static HostHealth fromWebmasterProblemSummaries(SummarySiteProblemsInfo realTimeProblemsInfo) {
        int totalWeight = 0;
        boolean haveFatal = false;
        int undefinedProblemsWeight = 0;
        if (realTimeProblemsInfo != null) {
            totalWeight += realTimeProblemsInfo.getProblemsWeight();
            haveFatal |= realTimeProblemsInfo.isHaveFatalProblems();
            undefinedProblemsWeight += realTimeProblemsInfo.getUndefinedProblemsWeight();
        }
        int health = haveFatal ? 0 : SiteProblemWeightUtil.TOTAL_PROBLEMS_WEIGHT - totalWeight - undefinedProblemsWeight;
        return new HostHealth(health, SiteProblemWeightUtil.TOTAL_PROBLEMS_WEIGHT - undefinedProblemsWeight);
    }

    public enum HealthStatus {
        VERY_BAD,
        BAD,
        NORMAL,
        GOOD
    }
}
