package ru.yandex.webmaster3.viewer.http.crawl;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.crawl.BaseCrawlInfo;
import ru.yandex.webmaster3.storage.crawl.UserCrawlSettings;
import ru.yandex.webmaster3.storage.crawl.service.CrawlSettingsService;
import ru.yandex.webmaster3.viewer.http.crawl.data.HostCrawlConstants;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("crawl")
@Description("Посмотреть настройки скорости обхода для хоста")
public class GetHostCrawlInfoAction extends Action<GetHostCrawlInfoRequest, GetHostCrawlInfoResponse> {
    private CrawlSettingsService crawlSettingsService;

    @Override
    public GetHostCrawlInfoResponse process(GetHostCrawlInfoRequest request) throws WebmasterException {
        UserCrawlSettings userSettings = crawlSettingsService.getUserCrawlSettings(request.getHostId());
        BaseCrawlInfo baseInfo = crawlSettingsService.getBaseCrawlInfo(request.getHostId());
        double rps = baseInfo.getCrawlRPS();
        return new GetHostCrawlInfoResponse(
                baseInfo,
                userSettings,
                new GetHostCrawlInfoResponse.MultiplierBounds(
                        HostCrawlConstants.MULTIPLIER_MIN,
                        HostCrawlConstants.MULTIPLIER_MAX,
                        rps < 0.1 ? 0.01 : 0.1
                )
        );
    }

    @Required
    public void setCrawlSettingsService(CrawlSettingsService crawlSettingsService) {
        this.crawlSettingsService = crawlSettingsService;
    }
}
