package ru.yandex.webmaster3.viewer.http.crawl;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.crawl.BaseCrawlInfo;
import ru.yandex.webmaster3.storage.crawl.UserCrawlSettings;

/**
 * @author avhaliullin
 */
public class GetHostCrawlInfoResponse implements ActionResponse {
    private final BaseCrawlInfo baseCrawlInfo;
    private final UserCrawlSettings userCrawlSettings;
    private final MultiplierBounds multiplierBounds;

    public GetHostCrawlInfoResponse(BaseCrawlInfo baseCrawlInfo, UserCrawlSettings userCrawlSettings, MultiplierBounds multiplierBounds) {
        this.baseCrawlInfo = baseCrawlInfo;
        this.userCrawlSettings = userCrawlSettings;
        this.multiplierBounds = multiplierBounds;
    }

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.SUCCESS;
    }

    @Description("базовая информация о скорости обхода")
    public BaseCrawlInfo getBaseCrawlInfo() {
        return baseCrawlInfo;
    }

    @Description("пользовательские настроки скорости обхода")
    public UserCrawlSettings getUserCrawlSettings() {
        return userCrawlSettings;
    }

    @Description("границы разрешенного диапазона мультпликатора")
    public MultiplierBounds getMultiplierBounds() {
        return multiplierBounds;
    }

    @Value
    @Getter
    @AllArgsConstructor
    public static class MultiplierBounds {
        double minValue;
        double maxValue;
        double step;
    }
}
