package ru.yandex.webmaster3.viewer.http.crawl;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.crawl.RotorSettings;
import ru.yandex.webmaster3.storage.crawl.service.CrawlSettingsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author leonidrom
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Category("crawl")
@Component("/host/rotorSettings/get")
@ReadAction
@Description("настройки роторения для хоста")
public class GetHostRotorSettingsAction extends Action<GetHostRotorSettingsAction.Req, GetHostRotorSettingsAction.Resp> {
    private final CrawlSettingsService crawlSettingsService;

    @Override
    public Resp process(Req req) throws WebmasterException {
        return new Resp(crawlSettingsService.getRotorSettings(req.getHostId()));
    }

    public static class Req extends AbstractUserVerifiedHostRequest {
    }

    public static class Resp implements ActionResponse.NormalResponse {
        private final RotorSettings.RenderSettings renderSettings;

        public Resp(RotorSettings rotorSettings) {
            this.renderSettings = rotorSettings.renderSettings();
        }

        @Description("настройки роторения")
        public RotorSettings.RenderSettings getRenderSettings() {
            return renderSettings;
        }
    }
}
