package ru.yandex.webmaster3.viewer.http.crawl;

import lombok.Getter;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.crawl.data.UrlRotorCheckInfo;

/**
 * @author leonidrom
 */
public abstract class GetUrlRotorCheckInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlRotorCheckInfoResponse implements ActionResponse.NormalResponse {
        private final UrlRotorCheckInfo checkInfoJSEnabled;
        private final UrlRotorCheckInfo checkInfoJSDisabled;

        @Getter
        private final boolean inProgress;

        public NormalResponse(UrlRotorCheckInfo checkInfoJSEnabled, UrlRotorCheckInfo checkInfoJSDisabled) {
            this.checkInfoJSEnabled = checkInfoJSEnabled;
            this.checkInfoJSDisabled = checkInfoJSDisabled;
            this.inProgress = false;
        }

        public NormalResponse() {
            this.checkInfoJSEnabled = null;
            this.checkInfoJSDisabled = null;
            this.inProgress = true;
        }

        @Description("Результат проверки роторения урла с включенным JS")
        public UrlRotorCheckInfo getCheckInfoJSEnabled() {
            return checkInfoJSEnabled;
        }

        @Description("Результат проверки роторения урла с выключенным JS")
        public UrlRotorCheckInfo getCheckInfoJSDisabled() {
            return checkInfoJSDisabled;
        }
    }

    public enum ErrorCode {
        REQUEST_ID_NOT_FOUND,
        TIMED_OUT,
        INTERNAL_ERROR,
        UNABLE_TO_DOWNLOAD_CONTENT
    }

    public static abstract class GetUrlRotorCheckErrorResponse extends GetUrlRotorCheckInfoResponse implements ActionResponse.ErrorResponse {
        private final ErrorCode errorCode;

        public GetUrlRotorCheckErrorResponse(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<ErrorCode> getCode() {
            return errorCode;
        }
    }

    @Description("Запрос не найден")
    public static class RequestIdNotFoundResponse extends GetUrlRotorCheckErrorResponse {
        public RequestIdNotFoundResponse() {
            super(ErrorCode.REQUEST_ID_NOT_FOUND);
        }
    }

    @Description("Проверка урла выполняется слишком долго")
    public static class TimedOutResponse extends GetUrlRotorCheckErrorResponse {
        public TimedOutResponse() {
            super(ErrorCode.TIMED_OUT);
        }
    }

    @Description("Проверка урла не удалась из за внутренней ошибки")
    public static class InternalErrorResponse extends GetUrlRotorCheckErrorResponse {
        public InternalErrorResponse() {
            super(ErrorCode.INTERNAL_ERROR);
        }
    }

    @Description("Не удалось скачать данные на стороне Робота")
    public static class UnableToDownloadContentResponse extends GetUrlRotorCheckErrorResponse {
        public UnableToDownloadContentResponse() {
            super(ErrorCode.UNABLE_TO_DOWNLOAD_CONTENT);
        }
    }
}
