package ru.yandex.webmaster3.viewer.http.crawl;

import lombok.Getter;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckDeviceType;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckRequestParams;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author leonidrom
 */
@Getter
public class StartUrlRotorCheckRequest extends AbstractUserVerifiedHostRequest {
    private final UrlCheckRequestParams requestParams = new UrlCheckRequestParams();

    @Description("Ширина скриншота")
    @RequestQueryProperty
    public void setScreenshotWidth(int screenshotWidth) {
        requestParams.screenshotWidth = screenshotWidth;
    }

    @Description("Высота скриншота")
    @RequestQueryProperty
    public void setScreenshotHeight(int screenshotHeight) {
        requestParams.screenshotHeight = screenshotHeight;
    }

    @Description("URL для проверки")
    @RequestQueryProperty(required = true)
    public void setUrl(String url) {
        requestParams.url = url;
    }

    @Description("Тип проверки")
    @RequestQueryProperty(required = true)
    public void setDeviceType(UrlCheckDeviceType deviceType) {
        requestParams.deviceType = deviceType;
    }

    public UrlCheckRequestParams getRequestParams() {
        return requestParams;
    }
}
