package ru.yandex.webmaster3.viewer.http.crawl;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.UUID;

/**
 * @author leonidrom
 */
public abstract class StartUrlRotorCheckResponse implements ActionResponse {
    public static class NormalResponse extends StartUrlRotorCheckResponse implements ActionResponse.NormalResponse {
        private final UUID requestId;

        public NormalResponse(UUID requestId) {
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }
    }

    public enum ErrorCode {
        INVALID_URL,
        URL_FROM_ANOTHER_HOST
    }

    public static abstract class StartUrlRotorCheckErrorResponse extends StartUrlRotorCheckResponse implements ActionResponse.ErrorResponse {
        private final ErrorCode errorCode;

        public StartUrlRotorCheckErrorResponse(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<ErrorCode> getCode() {
            return errorCode;
        }
    }

    @Description("Передан невалидный URL")
    public static class InvalidUrlResponse extends StartUrlRotorCheckErrorResponse {
        public InvalidUrlResponse() {
            super(ErrorCode.INVALID_URL);
        }
    }

    @Description("Переданный URL не относится к текущему хосту")
    public static class UrlIsNotFromHostResponse extends StartUrlRotorCheckErrorResponse {
        public UrlIsNotFromHostResponse() {
            super(ErrorCode.URL_FROM_ANOTHER_HOST);
        }
    }

}
