package ru.yandex.webmaster3.viewer.http.crawl;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.crawl.RotorSettings;
import ru.yandex.webmaster3.storage.crawl.service.CrawlSettingsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author leonidrom
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Category("crawl")
@Component("/host/rotorSettings/update")
@WriteAction
@Description("обновить настройки роторения для хоста")
public class UpdateHostRotorSettingsAction extends Action<UpdateHostRotorSettingsAction.Req, UpdateHostRotorSettingsAction.Resp> {
    private final CrawlSettingsService crawlSettingsService;

    @Override
    public Resp process(Req req) throws WebmasterException {
        var rotorSettings = new RotorSettings(req.getHostId(), req.getRenderSettings());
        crawlSettingsService.updateRotorSettings(rotorSettings);

        return new Resp();
    }

    public static class Req extends AbstractUserVerifiedHostRequest {
        private RotorSettings.RenderSettings renderSettings;

        @RequestQueryProperty(required = true)
        public void setRenderSettings(RotorSettings.RenderSettings renderSettings) {
            this.renderSettings = renderSettings;
        }

        public RotorSettings.RenderSettings getRenderSettings() {
            return renderSettings;
        }
    }

    public static class Resp implements ActionResponse.NormalResponse {
    }
}
