package ru.yandex.webmaster3.viewer.http.crawl.data;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import lombok.RequiredArgsConstructor;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.util.json.JsonMapping;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlock;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.PageTextContentTitleDescData;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.RotorCheckData;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.ServerResponseData;

import java.util.List;
import java.util.Map;

/**
 * @author leonidrom
 */
@RequiredArgsConstructor
public class UrlRotorCheckInfo {
    private final PageContent pageContent;
    private final HttpResponsePart technicalInfo;
    private final List<ServerResponseData.ResourceInfo> resourceInfos;

    @Description("Все про контент страницы")
    public PageContent getPageContent() {
        return pageContent;
    }

    @Description("Все про ответ сервера (без responseBody)")
    public HttpResponsePart getTechnicalInfo() {
        return technicalInfo;
    }

    @Description("Информация о ресурсах")
    public List<ServerResponseData.ResourceInfo> getResourceInfos() {
        return resourceInfos;
    }

    @RequiredArgsConstructor
    @Description("Контент страницы")
    public static class PageContent {
        private final String title;
        private final String description;
        private final String base64PNGScreenshot;
        private final String content;

        @Description("Title страницы")
        public String getTitle() {
            return title;
        }

        @Description("Description страницы")
        public String getDescription() {
            return description;
        }

        @Description("Скриншот страницы в формате base64 png")
        public String getBase64PNGScreenshot() {
            return base64PNGScreenshot;
        }

        @Description("Текстовый контент страницы")
        public String getContent() {
            return content;
        }
    }

    public static UrlRotorCheckInfo fromDataBlocks(
            UrlCheckDataBlock rotorCheckDataBlock,
            UrlCheckDataBlock pageDataBlock,
            UrlCheckDataBlock serverResponseDataBlock) {
        var rotorCheckData = JsonMapping.readValue(rotorCheckDataBlock.getData(), RotorCheckData.class);
        var pageData = JsonMapping.readValue(pageDataBlock.getData(), PageTextContentTitleDescData.class);
        var serverResponseData = JsonMapping.readValue(serverResponseDataBlock.getData(), ServerResponseData.class);

        PageContent pageContent = new PageContent(pageData.getTitle(), pageData.getDescription(),
                rotorCheckData.getBase64Screenshot(), pageData.getText());
        return new UrlRotorCheckInfo(pageContent, serverResponseData.getHttpResponsePart(),
                serverResponseData.getResourceInfos());
    }
}
