package ru.yandex.webmaster3.viewer.http.delurl;

import com.google.common.base.Strings;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.delurl.DelurlType;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.filter.HostIdFilterResponse;
import ru.yandex.webmaster3.core.http.request.CommonRequestInfoAware;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

import java.util.List;

/**
 * @author Oleg Bazdyrev
 */
public class AddDelurlMassRequestRequest extends AbstractFrontendRequest implements CommonRequestInfoAware {

    private long userId = 0L;
    private WebmasterHostId hostId;
    private List<String> urls;
    private DelurlType type = DelurlType.URL;
    private String userIp;
    private String yandexUid;
    private String frontendIp;

    public long getUserId() {
        return userId;
    }

    @RequestQueryProperty
    public void setUserId(long userId) {
        this.userId = userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    @RequestQueryProperty
    public void setHostId(String hostId) {
        try {
            if (Strings.isNullOrEmpty(hostId))
                return;
            this.hostId = IdUtils.webIdStringToHostId(hostId, true);
        } catch (Exception e) {
            throw new WebmasterException("Illegal host id",
                    new HostIdFilterResponse.IllegalHostIdPassed(getClass(), hostId), e);
        }
    }

    public List<String> getUrls() {
        return urls;
    }

    @RequestQueryProperty(required = true)
    @Description("Урлы для удаления")
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public DelurlType getType() {
        return type;
    }

    @RequestQueryProperty
    @Description("Тип запроса на удаление: урлы или префиксы (пока только один префикс)")
    public void setType(DelurlType type) {
        this.type = type;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    @Override
    public void setUserYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    @Override
    public void setFrontendIp(String frontendIp) {
        this.frontendIp = frontendIp;
    }
}
