package ru.yandex.webmaster3.viewer.http.delurl;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.delurl.DelUrlRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.List;

import static ru.yandex.webmaster3.viewer.http.delurl.AddDelurlMassRequestResponse.ErrorType.*;

/**
 * @author Oleg Bazdyrev
 */
public abstract class AddDelurlMassRequestResponse implements ActionResponse {

    public static class NormalResponse extends AddDelurlMassRequestResponse implements ActionResponse.NormalResponse {
        private final int quota;
        private final int quotaUsed;
        private final int quotaRemain;
        private final List<DelUrlRequest> urls;
        private final DelurlWarningType warning;
        private final List<String> invalidUrls;

        public NormalResponse(int quota, int quotaUsed, int quotaRemain, List<DelUrlRequest> urls, DelurlWarningType warning,
                              List<String> invalidUrls)
        {
            this.quota = quota;
            this.quotaUsed = quotaUsed;
            this.quotaRemain = quotaRemain;
            this.urls = urls;
            this.warning = warning;
            this.invalidUrls = invalidUrls;
        }

        public int getQuota() {
            return quota;
        }

        public int getQuotaUsed() {
            return quotaUsed;
        }

        public int getQuotaRemain() {
            return quotaRemain;
        }

        public List<DelUrlRequest> getUrls() {
            return urls;
        }

        public DelurlWarningType getWarning() {
            return warning;
        }

        public List<String> getInvalidUrls() {
            return invalidUrls;
        }
    }

    public enum DelurlWarningType {
        DELURL__INVALID_URLS,
    }

    public enum ErrorType {
        DELURL__QUOTA_LIMIT_EXCEEDED,
        DELURL__REQUEST_TOO_BIG,
        DELURL__NO_VALID_URLS,
        DELURL__NO_REASON_TO_DELETE
    }

    @Description("Квота на сегодня превышена")
    public static class QuotaExceededResponse extends AddDelurlMassRequestResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return DELURL__QUOTA_LIMIT_EXCEEDED;
        }
    }

    @Description("Слишком большой запрос (больше квоты)")
    public static class RequestTooBigResponse extends AddDelurlMassRequestResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return DELURL__REQUEST_TOO_BIG;
        }
    }

    @Description("Не передано ни одного валидного урла")
    public static class NoValidUrlsResponse extends AddDelurlMassRequestResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return DELURL__NO_VALID_URLS;
        }
    }

    public static class NoReasonToDeleteResponse extends AddDelurlMassRequestResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return DELURL__NO_REASON_TO_DELETE;
        }
    }
}
