package ru.yandex.webmaster3.viewer.http.delurl;

import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.RequestId;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;
import ru.yandex.webmaster3.core.http.request.UserDataAware;

/**
 * @author aherman
 */
public class AddDelurlRequestRequest implements ActionRequest, UserDataAware, RequestIdAware {
    private String url;
    private long userId;
    private String userIp;
    private String yandexUid;
    private String frontendIp;
    private RequestId requestId;

    public String getUrl() {
        return url;
    }

    @RequestQueryProperty(required = true)
    public void setUrl(String url) {
        this.url = url;
    }


    @RequestQueryProperty
    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getUserId() {
        return userId;
    }

    @Override
    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public void setYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    @Override
    public void setFrontendIp(String frontendIp) {
        this.frontendIp = frontendIp;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    @Override
    public void setBalancerRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    @Override
    public RequestId getBalancerRequestId() {
        return requestId;
    }
}
