package ru.yandex.webmaster3.viewer.http.delurl;

import ru.yandex.webmaster3.core.delurl.DelUrlRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author aherman
 */
public abstract class AddDelurlRequestResponse implements ActionResponse {

    public static class NormalResponse extends AddDelurlRequestResponse implements ActionResponse.NormalResponse {
        private final DelUrlRequest delurlRequest;

        public NormalResponse(DelUrlRequest delurlRequest) {
            this.delurlRequest = delurlRequest;
        }

        public DelUrlRequest getDelurlRequest() {
            return delurlRequest;
        }
    }

    public static enum Error {
        DELURL__QUOTA_LIMIT_EXCEEDED,
        DELURL__NO_REASON_TO_DELETE,
    }

    public static class QuotaLimitExceede extends AddDelurlRequestResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public QuotaLimitExceede(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override public Enum<?> getCode() {return Error.DELURL__QUOTA_LIMIT_EXCEEDED;}
        @Override public Class<?> getClazz() {return clazz;}
        @Override public String getMessage() {return "Quota limit exceeded";}
    }

    public static class NoReasonToDelete extends AddDelurlRequestResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        private final DelUrlRequest delurlRequest;

        public NoReasonToDelete(Class<?> clazz, DelUrlRequest delurlRequest) {
            this.clazz = clazz;
            this.delurlRequest = delurlRequest;
        }

        public DelUrlRequest getDelurlRequest() {
            return delurlRequest;
        }

        @Override public Enum<?> getCode() {return Error.DELURL__NO_REASON_TO_DELETE;}
        @Override public Class<?> getClazz() {return clazz;}
        @Override public String getMessage() {return "No reason to delete url";}
    }
}
