package ru.yandex.webmaster3.viewer.http.delurl;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.delurl.DelurlType;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.DailyQuotaUtil;
import ru.yandex.webmaster3.storage.delurl.DelUrlRequestsService;
import ru.yandex.webmaster3.storage.delurl.DelUrlService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Category("delurl")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class GetDelurlQuotaAction extends AbstractUserVerifiedHostAction<GetDelurlQuotaAction.Request, GetDelurlQuotaAction.Response> {
    private final DelUrlRequestsService delurlRequestsService;

    @Override
    public Response process(Request request) {
        DailyQuotaUtil.QuotaUsage quotaUsage = delurlRequestsService.getQuotaUsage(request.getHostId(), request.getType());
        return new Response(quotaUsage.getTodayQuota(), quotaUsage.getQuotaUsed(), quotaUsage.getQuotaRemain());
    }

    public static class Request extends AbstractUserVerifiedHostRequest {

        private DelurlType type = DelurlType.URL;

        public DelurlType getType() {
            return type;
        }

        @RequestQueryProperty
        @Description("Тип запроса на удаление: урлы или префиксы (пока только один префикс)")
        public void setType(DelurlType type) {
            this.type = type;
        }

    }

    public class Response implements ActionResponse.NormalResponse {
        private final int quota;
        private final int quotaUsed;
        private final int quotaRemain;

        public Response(int quota, int quotaUsed, int quotaRemain) {
            this.quota = quota;
            this.quotaUsed = quotaUsed;
            this.quotaRemain = quotaRemain;
        }

        public int getQuota() {
            return quota;
        }

        public int getQuotaUsed() {
            return quotaUsed;
        }

        public int getQuotaRemain() {
            return quotaRemain;
        }
    }
}
