package ru.yandex.webmaster3.viewer.http.download;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.viewer.http.SiteTreeNodeAware;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

import java.util.List;

/**
 * Created by ifilippov5 on 09.02.17.
 */
public class DownloadRequest<I extends Enum<I>, F extends AbstractFilter<I>> extends UsersVerifiedHostRequest {
    private List<F> parameterFilters;
    private FileFormat exportFormat;

    public List<F> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по примерам")
    @RequestPostProperty
    public void setParameterFilters(List<F> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    @Description("формат файла выгрузки")
    @RequestQueryProperty(required = true)
    public void setExportFormat(FileFormat exportFormat) {
        this.exportFormat = exportFormat;
    }
}
