package ru.yandex.webmaster3.viewer.http.download.links;

import com.google.common.hash.Hasher;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.download.common.LinkMdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.LinkType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;

@ReadAction
@Category("links")
public class DownloadInternalLinkArchiveAction extends DownloadAction2<DownloadLinkArchiveRequest> {

    private final static LinkType LINK_TYPE = LinkType.INTERNAL;

    @Override
    protected MdsExportDescriptor makeRequest(DownloadLinkArchiveRequest request) {
        WebmasterHostId hostId = request.getHostId();
        String name = hostId.getSchema().getSchemaName() + "://" + hostId.getPunycodeHostname();
        return new LinkMdsExportDescriptor(name, LINK_TYPE);
    }

    @Override
    protected void customizeHash(Hasher h, DownloadLinkArchiveRequest request) {
        h.putInt(LINK_TYPE.ordinal());
    }
}
