package ru.yandex.webmaster3.viewer.http.download.metrika;

import com.google.common.hash.Hasher;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.metrika.counters.MetrikaCountersUtil;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.MetrikaCrawlSamplesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlSamplesService;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;

import java.nio.charset.StandardCharsets;

/**
 * @author leonidrom
 */

@WriteAction
@Category("metrika")
@Description("Скачать семплы урлов, которые обходятся на домене по счетчику")
public class DownloadMetrikaCrawlSamplesAction extends DownloadAction2<DownloadMetrikaCrawlSamplesRequest> {
    private final MetrikaCrawlSamplesService metrikaCrawlSamplesService;

    @Autowired
    public DownloadMetrikaCrawlSamplesAction(MetrikaCrawlSamplesService metrikaCrawlSamplesService) {
        this.metrikaCrawlSamplesService = metrikaCrawlSamplesService;
    }

    @Override
    protected MdsExportDescriptor makeRequest(DownloadMetrikaCrawlSamplesRequest request) {
        String domain = MetrikaCountersUtil.hostToPunycodeDomain(request.getHostId());
        return new MetrikaCrawlSamplesMdsExportDescriptor(
                domain, request.getCounterId(), request.getParameterFilters());
    }

    @Override
    protected void customizeHash(Hasher h, DownloadMetrikaCrawlSamplesRequest request) {
        String domain = MetrikaCountersUtil.hostToPunycodeDomain(request.getHostId());
        h.putString(domain, StandardCharsets.UTF_8);
        h.putLong(request.getCounterId());
        h.putLong(metrikaCrawlSamplesService.getSampleLastUpdateTime(domain, request.getCounterId()).getMillis());
    }
}
