package ru.yandex.webmaster3.viewer.http.download.searchquery;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.storage.download.searchquery.DownloadUrlsIndicatorStatisticTaskData;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction;

/**
 * @author lester
 */
@ReadAction
@Category("searchquery")
public class AllUrlsOneIndicatorWholePeriodAction extends DownloadAction<DownloadStatisticUrlIndicatorRequest> {

    @Override
    protected WorkerTaskData getTaskData(DownloadStatisticUrlIndicatorRequest downloadRequest, long hash) {
        DownloadStatisticUrlIndicatorRequest request = (DownloadStatisticUrlIndicatorRequest) downloadRequest;
        String fileName = generateFileName(request, hash);
        return DownloadUrlsIndicatorStatisticTaskData.createTaskData(
                request.getHostId(),
                request.getLocalDateFrom(),
                request.getLocalDateTo(),
                request.getRegionId(),
                request.getRegionInclusion(),
                request.getSpecialGroup(),
                request.getDeviceType(),
                request.getOrderBy(),
                request.getOrderDirection(),
                request.getIndicator(),
                request.getPeriod(),
                request.getExportFormat(),
                fileName,
                hash);
    }

    @Override
    protected long getHash(DownloadStatisticUrlIndicatorRequest request) {
        HashFunction hf = Hashing.md5();

        Hasher hc = hf.newHasher()
                .putInt(request.getHostId().hashCode())
                .putString(request.getExportFormat().toString(), Charsets.UTF_8)
                .putString("allUrlsOneIndicatorListStatistics", Charsets.UTF_8);

        if (request.getLocalDateFrom() != null)
            hc.putString(request.getLocalDateFrom().toString(), Charsets.UTF_8);
        if (request.getLocalDateTo() != null)
            hc.putString(request.getLocalDateTo().toString(), Charsets.UTF_8);

        if (request.getRegionId() != null) {
            for (Integer regionId : request.getRegionId()) {
                hc.putInt(regionId);
            }
        }

        if (request.getRegionInclusion() != null) {
            hc.putString(request.getRegionInclusion().toString(), Charsets.UTF_8);
        }

        if (request.getOrderBy() != null) {
            hc.putString(request.getOrderBy().toString(), Charsets.UTF_8);
        }

        if (request.getOrderDirection() != null) {
            hc.putString(request.getOrderDirection().toString(), Charsets.UTF_8);
        }

        if (request.getSpecialGroup() != null) {
            hc.putString(request.getSpecialGroup().toString(), Charsets.UTF_8);
        }

        if (request.getIndicator() != null) {
            hc.putString(request.getIndicator().toString(), Charsets.UTF_8);
        }

        if (request.getPeriod() != null) {
            hc.putString(request.getPeriod().toString(), Charsets.UTF_8);
        }
        hc.putString(request.getDeviceType().name(), Charsets.UTF_8);

        return hc.hash().asLong();
    }
}
