package ru.yandex.webmaster3.viewer.http.download.searchquery;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.searchquery.statistic.DateRangeAware;

/**
 * Created by ifilippov5 on 03.03.17.
 */
public class DownloadStatisticRequest extends UsersVerifiedHostRequest implements DateRangeAware {
    private FileFormat exportFormat;
    private DateTime dateFrom;
    private DateTime dateTo;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private DeviceType deviceType = DeviceType.ALL_DEVICES;

    public DeviceType getDeviceType() {
        return deviceType;
    }

    @RequestQueryProperty
    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    @Description("формат файла выгрузки")
    @RequestQueryProperty(required = true)
    public void setExportFormat(FileFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }
}
