package ru.yandex.webmaster3.viewer.http.download.searchquery;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.storage.download.searchquery.DownloadStatisticSelectedQueryAllIndicatorsTaskData;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction;

/**
 * Created by ifilippov5 on 08.03.17.
 */
@ReadAction
@Category("searchquery")
public class OneQueryAllIndicatorsByDataAction extends DownloadAction<DownloadStatisticSelectedQueryRequest> {
    @Override
    protected WorkerTaskData getTaskData(DownloadStatisticSelectedQueryRequest request, long hash) {
        String fileName = generateFileName(request, hash);
        return DownloadStatisticSelectedQueryAllIndicatorsTaskData.createTaskData(
                request.getHostId(),
                request.getLocalDateFrom(),
                request.getLocalDateTo(),
                request.getRegionId(),
                request.getRegionInclusion(),
                request.getSpecialGroup(),
                request.getQueryId(),
                request.getDeviceType(),
                request.getPeriod(),
                request.getExportFormat(),
                fileName,
                hash);
    }

    @Override
    protected long getHash(DownloadStatisticSelectedQueryRequest request) {
        HashFunction hf = Hashing.md5();

        Hasher hc = hf.newHasher()
                .putInt(request.getHostId().hashCode())
                .putString(request.getExportFormat().toString(), Charsets.UTF_8)
                .putString("oneQueryAllIndicatorsStatistics", Charsets.UTF_8);
        //.putString(searchUrlSamplesService.getEventSamplesDataVersion(), Charsets.UTF_8);TODO

        if (request.getLocalDateFrom() != null)
            hc.putString(request.getLocalDateFrom().toString(), Charsets.UTF_8);
        if (request.getLocalDateTo() != null)
            hc.putString(request.getLocalDateTo().toString(), Charsets.UTF_8);

        if (request.getRegionId() != null) {
            for (Integer regionId : request.getRegionId()) {
                hc.putInt(regionId);
            }
        }

        if (request.getRegionInclusion() != null) {
            hc.putString(request.getRegionInclusion().toString(), Charsets.UTF_8);
        }

        if (request.getSpecialGroup() != null) {
            hc.putString(request.getSpecialGroup().toString(), Charsets.UTF_8);
        }

        if (request.getQueryId() != null) {
            hc.putString(request.getQueryId().toString(), Charsets.UTF_8);
        }

        if (request.getPeriod() != null) {
            hc.putString(request.getPeriod().toString(), Charsets.UTF_8);
        }
        hc.putString(request.getDeviceType().name(), Charsets.UTF_8);

        return hc.hash().asLong();
    }
}
