package ru.yandex.webmaster3.viewer.http.download.turbo;

import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.TurboTopPagesWithoutTurboMdsExportDescriptor;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * ishalaru
 * 27.03.2020
 **/
@ReadAction
@Component("/turbo/statistics/url/clicks/download")
public class DownloadTopUrlsWithoutTurbo extends DownloadAction2<DownloadTopUrlsWithoutTurbo.Request> {
    @Override
    protected MdsExportDescriptor makeRequest(Request request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        return new TurboTopPagesWithoutTurboMdsExportDescriptor(domain);
    }

    public static class Request extends DownloadRequest<TopUrlEnum, AbstractFilter<TopUrlEnum>> {
    }
    public enum TopUrlEnum{

    }
}
