package ru.yandex.webmaster3.viewer.http.download.turbo;

import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.TurboAutoDeletedPagesMdsExportDescriptor;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * ishalaru
 * 27.03.2020
 **/
@ReadAction
@Category("turbo")
@Component("/turbo/statistics/url/autoDeleted/download")
public class DownloadTurboAutoDeletedPagesAction extends DownloadAction2<DownloadTurboAutoDeletedPagesAction.Request> {
    @Override
    protected MdsExportDescriptor makeRequest(Request request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        return new TurboAutoDeletedPagesMdsExportDescriptor(domain);
    }

    public static class Request extends DownloadRequest<AutoDeletedPageEnum, AbstractFilter<AutoDeletedPageEnum>> {
    }
    public enum AutoDeletedPageEnum {

    }
}
