package ru.yandex.webmaster3.viewer.http.download.turbo;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.TurboSearchUrlSamplesMdsExportDescriptor;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;

@ReadAction
@Category("turbo")
@Component("/searchurl/turbo/samples/download")
public class DownloadTurboSearchUrlSamplesAction extends DownloadAction2<DownloadTurboSearchUrlSamplesRequest> {
    @Override
    protected MdsExportDescriptor makeRequest(DownloadTurboSearchUrlSamplesRequest request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        return new TurboSearchUrlSamplesMdsExportDescriptor(domain, request.getUserId(), request.getTurboType());
    }

    @Override
    protected long getHash(DownloadTurboSearchUrlSamplesRequest request) {
        HashFunction hf = Hashing.md5();

        String domain = WwwUtil.cutWWWAndM(request.getHostId());

        Hasher hc = hf.newHasher()
                .putString(domain, Charsets.UTF_8)
                .putLong(request.getUserId())
                .putInt(request.getTurboType().ordinal());

        return hc.hash().asLong();
    }

}
