package ru.yandex.webmaster3.viewer.http.download.turbo;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.turbo.model.TurboType;
import ru.yandex.webmaster3.storage.searchurl.TurboSearchUrlFilter;
import ru.yandex.webmaster3.storage.searchurl.TurboSearchUrlSampleField;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

public class DownloadTurboSearchUrlSamplesRequest extends DownloadRequest<TurboSearchUrlSampleField, TurboSearchUrlFilter> {
    private TurboType turboType = TurboType.CONTENT;

    @Override
    public FileFormat getExportFormat() {
        // quick and dirty way to ensure only CSV format is allowed here
        return FileFormat.CSV;
    }

    public TurboType getTurboType() {
        return turboType;
    }

    @Description("Тип Турбо")
    @RequestQueryProperty
    public void setTurboType(TurboType turboType) {
        this.turboType = turboType;
    }
}
