package ru.yandex.webmaster3.viewer.http.download.userurls;

import com.google.common.hash.Hasher;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.download.common.*;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;

/**
 * @author lester
 */
@ReadAction
@Category("userurls")
public class DownloadUserUrlsSerpShowsArchiveAction extends DownloadAction2<DownloadUserUrlsArchiveRequest> {

    @Override
    protected MdsExportDescriptor makeRequest(DownloadUserUrlsArchiveRequest request) {
        WebmasterHostId hostId = request.getHostId();
        String name = hostId.getSchema().getSchemaName() + "://" + hostId.getPunycodeHostname();
        return new UserUrlsMdsExportDescriptor(name, UserUrlsType.SERP_SHOWS);
    }

    @Override
    protected void customizeHash(Hasher h, DownloadUserUrlsArchiveRequest request) {
        h.putBytes(getClass().getName().getBytes());
        h.putInt(UserUrlsType.SERP_SHOWS.ordinal());
    }
}
