package ru.yandex.webmaster3.viewer.http.favicons;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.favicon.FaviconInfo;
import ru.yandex.webmaster3.storage.favicon.HostFaviconsCHDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * Created by Oleg Bazdyrev on 11/08/2020.
 */
@ReadAction
@Category("favicons")
@Component("/favicons/list")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetHostFaviconsAction extends AbstractUserVerifiedHostAction<GetHostFaviconsAction.Request,
        GetHostFaviconsAction.Response> {

    private final HostFaviconsCHDao mdbHostFaviconsCHDao;

    @Override
    public Response process(Request request) {
        return new Response(mdbHostFaviconsCHDao.getFavicons(request.getHostId()));
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

    }

    @Value
    public static final class Response implements ActionResponse.NormalResponse {
        @Description("Известные фавиконки хоста")
        List<FaviconInfo> favicons;
    }
}
