package ru.yandex.webmaster3.viewer.http.feedback.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feedback.FeedbackType;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author: ishalaru
 * DATE: 03.06.2019
 */
public class FeedbackCreateRequest extends AbstractUserRequest {
    private FeedbackType type;
    private String message;
    private String meta;
    private WebmasterHostId hostId;

    @Description("Тип фидбека от пользователя.")
    @RequestQueryProperty(required = true)
    public void setType(FeedbackType type) {
        this.type = type;
    }

    public FeedbackType getType() {
        return type;
    }

    @Description("Текст фидбека")
    @RequestQueryProperty(required = true)
    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    @RequestQueryProperty()
    public void setHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Description("Мета данный в виде JSON, в помощь для дальнейшего анализа данных")
    @RequestQueryProperty()
    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMeta() {
        return meta;
    }
}
