package ru.yandex.webmaster3.viewer.http.feedback.model;

import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author: ishalaru
 * DATE: 03.06.2019
 */
public abstract class FeedbackCreateResponse implements ActionResponse {
    public static class NormalResponse extends FeedbackCreateResponse implements ActionResponse.NormalResponse {

    }

    enum FeedbackErrorResponseType {
        MESSAGE_IS_EMPTY,
        MESSAGE_IS_TOO_LONG,
        META_IS_TOO_LONG,
        CREATE_EMAIL_IS_FAILED,
        HOST_ID_IS_MISSING,
    }

    public static class MessageIsEmpty extends FeedbackCreateResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return FeedbackErrorResponseType.MESSAGE_IS_EMPTY;
        }
    }

    public static class MessageIsTooLong extends FeedbackCreateResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return FeedbackErrorResponseType.MESSAGE_IS_TOO_LONG;
        }
    }

    public static class MetaIsTooLong extends FeedbackCreateResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return FeedbackErrorResponseType.META_IS_TOO_LONG;
        }
    }

    public static class CreateEmailIsFailed extends FeedbackCreateResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return FeedbackErrorResponseType.CREATE_EMAIL_IS_FAILED;
        }
    }

    public static class HostIdIsMissing extends FeedbackCreateResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return FeedbackErrorResponseType.HOST_ID_IS_MISSING;
        }
    }


}
