package ru.yandex.webmaster3.viewer.http.feedback.model;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author: ishalaru
 * DATE: 03.06.2019
 */
public class GetFeedbackActionRequest extends AbstractUserVerifiedHostRequest {
    private DateTime startDate;
    private DateTime endDate;
    private int limit;

    public DateTime getStartDate() {
        return startDate;
    }

    @Description("Дата сохранения фибдека, начало периода")
    @RequestQueryProperty(required = false)
    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public DateTime getEndDate() {
        return endDate;
    }

    @Description("Дата сохранения фибдека, конец периода")
    @RequestQueryProperty(required = false)
    public void setEndDate(DateTime endDate) {
        this.endDate = endDate;
    }


    public int getLimit() {
        return limit;
    }

    @Description("Лимит на возвращаемое кол-во фидбеков")
    @RequestQueryProperty(required = false)
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
