package ru.yandex.webmaster3.viewer.http.feeds;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

public interface AddFeedResponse extends ActionResponse {

    class NormalResponse implements AddFeedResponse, ActionResponse.NormalResponse {
    }


    enum ErrorCode {
        FEED_ALREADY_ADDED,
        INVALID_URL,
        BAD_URL_HTTP_CODE,
        BAD_URL_MIME_TYPE,
        HTTPS_ONLY,
        REQUEST_ID_NOT_FOUND,
        TIMED_OUT,
        NO_REGIONS,

        FEED_BANNED,
    }

    abstract class AbstractAddFeedError implements AddFeedResponse, ActionResponse.ErrorResponse {
        private final ErrorCode code;

        public AbstractAddFeedError(ErrorCode code) {
            this.code = code;
        }

        @Override
        public Enum<?> getCode() {
            return code;
        }
    }

    @Description("Фид и регион уже добавлены")
    class FeedAlreadyAddedResponse extends AbstractAddFeedError {
        public FeedAlreadyAddedResponse() {
            super(ErrorCode.FEED_ALREADY_ADDED);
        }
    }

    @Description("Урл в неверном формате")
    class InvalidUrlResponse extends AbstractAddFeedError {
        public InvalidUrlResponse() {
            super(ErrorCode.INVALID_URL);
        }
    }

    @Description("Попробовали скачать фид но у него код != 2хх")
    class BadUrlHttpCodeResponse extends AbstractAddFeedError {
        public BadUrlHttpCodeResponse() {
            super(ErrorCode.BAD_URL_HTTP_CODE);
        }
    }

    @Description("Попробовали скачать фид но у него MimeType отличный от")
    class BadUrlMimeTypeResponse extends AbstractAddFeedError {
        public BadUrlMimeTypeResponse() {
            super(ErrorCode.BAD_URL_MIME_TYPE);
        }
    }

    @Description("Фид забанен")
    class FeedBannedResponse extends AbstractAddFeedError {
        public FeedBannedResponse() {
            super(ErrorCode.FEED_BANNED);
        }
    }

    @Description("Поддерживаем только https протокол")
    class HttpsOnlyResponse extends AbstractAddFeedError {
        public HttpsOnlyResponse() {
            super(ErrorCode.HTTPS_ONLY);
        }
    }


    class RequestIdNotFoundResponse extends AbstractAddFeedError {
        public RequestIdNotFoundResponse() {
            super(ErrorCode.REQUEST_ID_NOT_FOUND);
        }
    }

    @Description("Проверка урла выполняется слишком долго (более 60 сек)")
    class TimedOutResponse extends AbstractAddFeedError {
        public TimedOutResponse() {
            super(ErrorCode.TIMED_OUT);
        }
    }

    @Description("Регионы обязательны")
    class NoRegionsResponse extends AbstractAddFeedError {
        public NoRegionsResponse() {
            super(ErrorCode.NO_REGIONS);
        }
    }


}
