package ru.yandex.webmaster3.viewer.http.feeds;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feeds.feed.ExternalFeedInfo;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.feeds.FeedsExternalYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;


/**
 * @author kravchenko99
 * @date 7/30/21
 */

@Component("/feeds/getExternalFeeds")
@ReadAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Category("feeds")
//todo конкретно переделать
public class GetExternalFeedsAction extends Action<GetExternalFeedsAction.Req, GetExternalFeedsAction.Res> {

    private final FeedsExternalYDao feedsExternalYDao;

    @Override
    public Res process(Req request) throws WebmasterException {
        WebmasterHostId hostId = request.getHostId();
        String domain = WwwUtil.cutWWWAndM(hostId);
        List<ExternalFeedInfo> list = feedsExternalYDao.list(domain);
        return new Res(list);
    }

    @Setter(onMethod_ = @RequestQueryProperty)
    public static class Req extends AbstractUserVerifiedHostRequest {
    }

    @Value
    public static class Res implements ActionResponse.NormalResponse {
        List<ExternalFeedInfo> feedInfos;
    }
}
