package ru.yandex.webmaster3.viewer.http.feeds.download;

import com.google.common.hash.Hasher;
import lombok.Setter;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.UserUrlsMdsExportField;
import ru.yandex.webmaster3.storage.download.common.UserUrlsMdsExportFilter;
import ru.yandex.webmaster3.storage.feeds.download.FeedsErrorsMdsExportDescriptor;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * Created by Oleg Bazdyrev on 18/01/2022.
 */
@ReadAction
@Category("feeds")
@Component("/feeds/download/qualityErrors")
public class DownloadFeedsQualityErrorsAction extends DownloadAction2<DownloadFeedsQualityErrorsAction.Request> {

    @Override
    protected MdsExportDescriptor makeRequest(Request request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        return new FeedsErrorsMdsExportDescriptor.FeedsQualityErrorsMdsExportDescriptor(
                request.getUserId(), domain, request.feed, request.timestamp.getMillis() / 1000L);
    }

    @Override
    protected String generateFileName(Request request, long hash) {
        return "errors-sets-feed-" + WwwUtil.cutWWWAndM(request.getHostId()) + "_" + request.timestamp;
    }

    @Override
    protected void customizeHash(Hasher h, Request request) {
        h.putBytes(getClass().getName().getBytes());
        h.putBytes(request.feed.getBytes());
        h.putLong(request.timestamp.getMillis());
    }

    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static final class Request extends DownloadRequest<UserUrlsMdsExportField, UserUrlsMdsExportFilter> {
        String feed;
        DateTime timestamp;
    }
}
