package ru.yandex.webmaster3.viewer.http.feeds.scc;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feeds.feed_domain.FeedDomainInfo;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.feeds.FeedsDomainInfoYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;


/**
 * @author kravchenko99
 * @date 7/30/21
 */

@Component("/feeds/getDomainSccStatus")
@ReadAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Category("feeds")
public class GetDomainSccStatusAction extends Action<GetDomainSccStatusAction.Req, GetDomainSccStatusAction.Res> {
    private final FeedsDomainInfoYDao feedsDomainInfoYDao;

    @Override
    public Res process(Req request) throws WebmasterException {
        WebmasterHostId hostId = request.getHostId();
        String domain = WwwUtil.cutWWWAndM(hostId);
        var feedDomainInfoOpt = feedsDomainInfoYDao.get(domain);
        FeedDomainInfo feedDomainInfo = feedDomainInfoOpt.orElse(FeedDomainInfo.empty(domain));
        return new Res(feedDomainInfo);
    }

    @Setter(onMethod_ = @RequestQueryProperty)
    public static class Req extends AbstractUserVerifiedHostRequest {

    }

    @Value
    public static class Res implements ActionResponse.NormalResponse {
        FeedDomainInfo feedDomainInfo;
    }
}
